# načtení názvů států ze souboru s plochami
plochy = []
with open('staty_plochy.log') as soubor:
    for řádka in soubor:
        stát, plocha = řádka.rstrip('\n').split(': ')
        plochy.append(stát)

# načtení názvů států ze souboru s počtem obyvatel
lidi = []
with open('staty_lidi.log') as soubor:
    for řádka in soubor:
        stát, počet_obyvatel = řádka.rstrip('\n').split(': ')
        lidi.append(stát)

# převedeme seznamy na množiny
plochy = set(plochy)
lidi = set(lidi)

# a prozkoumáme je
rozdíl_1 = plochy - lidi
print(rozdíl_1)
print(len(rozdíl_1))    # 24

rozdíl_2 = lidi - plochy
print(rozdíl_2)
print(len(rozdíl_2))    # 0

'''
{'Akrotiri', 'Europa Island', 'Tromelin Island', 'Wake Island', 'Howland Island', 'South Georgia and the South Sandwich Islands', 'Dhekelia', 'Baker Island', 'Coral Sea Islands', 'British Indian Ocean Territory', 'Ashmore and Cartier Islands', 'Jarvis Island', 'Glorioso Islands', 'Bouvet Island', 'Bassas da India', 'Midway Islands', 'Palmyra Atoll', 'Juan de Nova Island', 'Navassa Island', 'Jan Mayen', 'Spratly Islands', 'French Southern and Antarctic Lands', 'Clipperton Island', 'Kingman Reef'}
24
set()
0
'''
